# 💡 Proposal
<!--
Use this template to request a feature or propose some change in the browser.
The issue will likely be edited many times over its life to flesh out the various
questions, so if you don't know the answers to something, jut leave it blank!

The issue's title MUST provide a succinct description of proposal.

Some good (hypothetical) titles:
- Remove 'Safer' option from Security Level
- Bundle uBlock Origin by default
- Replace NoScript with faith-based JavaScript sand-boxing
-->

## User Story
<!--
Provide a high-level summary of the proposed feature, the problem it solves, and
what it would allow users to do if implemented. -->

## Security and Privacy Implications
<!--
How would this proposal interact with our the browser's threat model?
Would this feature negatively affect the browser's security or privacy
guarantees?
-->

### Security
<!--
Outline any security implications this feature would introduce. The browser's
security requirements can be found in our threat model document here:
- https://gitlab.torproject.org/tpo/applications/wiki/-/wikis/Design-Documents/Tor-Browser-Design-Doc#21-security-requirements
-->

### Privacy
<!--
Outline any privacy implications this feature would introduce. The browser's
privacy requirements can be found in our threat model document here:
- https://gitlab.torproject.org/tpo/applications/wiki/-/wikis/Design-Documents/Tor-Browser-Design-Doc#22-privacy-requirements
-->

## Accessibility Implications
<!--
Would this proposal affect or interact with the browser's usability for users
with accessibility needs (e.g. vision or mobility issues). What problems would need
to be solved to ensure these users are not left behind?
-->

## Other Trade-Offs
<!--
Beyond the security, privacy and accessibility implications, what other implications
are there for users?
-->

## Prior Art

### Does this feature exist in other browsers?
- [ ] Yes
    - [ ] Firefox
    - [ ] Firefox ESR
    - [ ] Other (please specify)
- [ ] No

### Does this feature exist as an extension? If yes, which one provides this functionality?

<!-- Do not edit beneath this line <3 -->

---

/label ~"Apps::Product::TorBrowser"
/label ~"Apps::Type::Proposal"
